package tocraft.craftedcore.event.common;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3222;
import net.minecraft.class_8779;
import tocraft.craftedcore.event.Event;
import tocraft.craftedcore.event.EventFactory;

@SuppressWarnings("unused")
public final class PlayerEvents {
    public static final Event<PlayerJoin> PLAYER_JOIN = EventFactory.createWithVoid();
    public static final Event<PlayerQuit> PLAYER_QUIT = EventFactory.createWithVoid();
    /**
     * Called when the player is recreated
     */
    public static final Event<PlayerRespawn> PLAYER_RESPAWN = EventFactory.createWithVoid();
    public static final Event<AwardAdvancement> AWARD_ADVANCEMENT = EventFactory.createWithVoid();
    public static final Event<RevokeAdvancement> REVOKE_ADVANCEMENT = EventFactory.createWithVoid();

    @Environment(EnvType.CLIENT)
    @FunctionalInterface
    public interface PlayerJoin {
        void join(class_3222 player);
    }

    @Environment(EnvType.CLIENT)
    @FunctionalInterface
    public interface PlayerQuit {
        void quit(class_3222 player);
    }

    @Environment(EnvType.CLIENT)
    @FunctionalInterface
    public interface PlayerRespawn {
        void clone(class_3222 oldPlayer, class_3222 newPlayer);
    }

    @Environment(EnvType.CLIENT)
    @FunctionalInterface
    public interface AwardAdvancement {
        void award(class_3222 player, class_8779 advancement, String criterionKey);
    }

    @FunctionalInterface
    public interface RevokeAdvancement {
        void revoke(class_3222 player, class_8779 advancement, String criterionKey);
    }
}
