package tocraft.craftedcore.config;

import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.network.ModernNetworking;

import java.nio.file.Path;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

@SuppressWarnings("unused")
public interface Config {
    @Nullable
    String getName();

    @Nullable
    default Path getPath() {
        return getName() != null ? ConfigLoader.getConfigPath(getName()) : null;
    }

    default void save() {
        ConfigLoader.writeConfigFile(this);
    }

    default void sendToPlayer(class_3222 target) {
        ModernNetworking.sendToPlayer(target, ConfigLoader.CONFIG_SYNC, ConfigLoader.getConfigSyncTag(this));
    }

    default void sendToAllPlayers(class_3218 serverLevel) {
        for (class_3222 target : serverLevel.method_18456()) {
            sendToPlayer(target);
        }
    }
}
