package tocraft.craftedcore;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.LiteralCommandNode;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import tocraft.craftedcore.event.common.CommandEvents;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.patched.CCommandSourceStack;
import tocraft.craftedcore.patched.TComponent;

public class CraftedCoreCommand {

    //#if MC>1182
    public static void initialize() {
        CommandEvents.REGISTRATION.register((dispatcher, ctx, selection) -> register(dispatcher));
    }
    //#else
    //$$ public static void initialize() {
    //$$     CommandEvents.REGISTRATION.register((dispatcher, ctx) -> register(dispatcher));
    //$$ }
    //#endif

    private static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralCommandNode<class_2168> craftedcore = class_2170.method_9247(CraftedCore.MODID)
                .then(class_2170.method_9247("clear").then(class_2170.method_9247("cache")
                        .executes(context -> {
                            CraftedCore.clearCache();
                            for (class_3218 level : context.getSource().method_9211().method_3738()) {
                                ModernNetworking.sendToPlayers(level.method_18456(), CraftedCore.CLEAR_CACHE_PACKET, new class_2487());
                            }
                            CCommandSourceStack.sendSuccess(context.getSource(), TComponent.translatable("craftedcore.command.clear_cache"), true);
                            return 1;
                        })))
                .build();
        dispatcher.getRoot().addChild(craftedcore);
    }
}
