/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import tocraft.craftedcore.CraftedCore;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.patched.Identifier;
import tocraft.craftedcore.platform.PlatformData;

public abstract class SynchronizedJsonReloadListener
extends class_4309 {
    public final class_2960 RELOAD_SYNC;
    protected final String directory;
    protected final Gson gson;
    private final Map<class_2960, JsonElement> map = new HashMap<class_2960, JsonElement>();

    public SynchronizedJsonReloadListener(Gson gson, String directory) {
        super(gson, directory);
        this.gson = gson;
        this.directory = directory;
        this.RELOAD_SYNC = CraftedCore.id("data_sync_" + directory);
    }

    protected void apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profiler) {
        this.map.clear();
        this.map.putAll(map);
        this.onApply(map);
    }

    protected abstract void onApply(Map<class_2960, JsonElement> var1);

    public void sendSyncPacket(class_3222 player) {
        class_2487 compound = new class_2487();
        this.map.forEach((key, json) -> compound.method_10582(key.toString(), json.toString()));
        ModernNetworking.sendToPlayer(player, this.RELOAD_SYNC, compound);
    }

    @Environment(value=EnvType.CLIENT)
    private void onPacketReceive(ModernNetworking.Context context, class_2487 compound) {
        this.map.clear();
        if (compound != null) {
            for (String key : compound.method_10541()) {
                this.map.put(Identifier.parse(key), JsonParser.parseString((String)compound.method_10558(key)));
            }
        }
        if (PlatformData.getEnv() == EnvType.CLIENT) {
            this.onApply(this.map);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void registerPacketReceiver() {
        ModernNetworking.registerReceiver(ModernNetworking.Side.S2C, this.RELOAD_SYNC, this::onPacketReceive);
    }
}

