package tocraft.craftedcore.network;

import Type;
import dev.architectury.injectables.annotations.ExpectPlatform;
import io.netty.buffer.Unpooled;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_634;
import net.minecraft.class_8710;
//#if MC>=1205
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import java.util.Map;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.ApiStatus;

@SuppressWarnings("unused")
public class ModernNetworking {
    //#if MC>=1205
    private static final Map<class_2960, class_8710.Type<PacketPayload>> TYPES = new HashMap<>();
    //#endif

    @ExpectPlatform
    public static void registerReceiver(Side side, class_2960 id, Receiver receiver) {
        throw new AssertionError();
    }

    //#if MC>=1205
    @ExpectPlatform
    public static void registerType(class_2960 id) {
        throw new AssertionError();
    }
    
    public static class_8710.Type<PacketPayload> getType(class_2960 id) {
        if (!TYPES.containsKey(id)) {
            TYPES.put(id, new class_8710.Type<>(id));
        }
        return TYPES.get(id);
    }
    //#endif

    public static void sendToPlayer(class_3222 player, class_2960 packetId, class_2487 data) {
        //#if MC>=1205
        player.field_13987.method_14364(toPacket(Side.S2C, new PacketPayload(packetId, data)));
        //#elseif MC>1201
        //$$ player.connection.send(toPacket(Side.S2C, packetId, data));
        //#else
        //$$ player.connection.send(toPacket(Side.S2C, packetId, data));
        //#endif
    }

    public static void sendToPlayers(Iterable<class_3222> players, class_2960 packetId, class_2487 data) {
        for (class_3222 player : players) {
            sendToPlayer(player, packetId, data);
        }
    }

    @Environment(EnvType.CLIENT)
    public static void sendToServer(class_2960 packetId, class_2487 data) {
        class_634 connection = class_310.method_1551().method_1562();

        if (connection != null) {
            //#if MC>=1205
            connection.method_52787(toPacket(Side.C2S, new PacketPayload(packetId, data)));
            //#elseif MC>1201
            //$$ connection.send(toPacket(Side.C2S, packetId, data));
            //#else
            //$$ connection.send(toPacket(Side.C2S, packetId, data));
            //#endif
        }
    }

    //#if MC>=1205
    @ExpectPlatform
    @ApiStatus.Internal
    public static class_2596<?> toPacket(ModernNetworking.Side side, class_8710 payload) {
        throw new AssertionError();
    }
    //#else
    //$$ @ExpectPlatform
    //$$ @ApiStatus.Internal
    //$$ public static Packet<?> toPacket(ModernNetworking.Side side, ResourceLocation id, CompoundTag data) {
    //$$     throw new AssertionError();
    //$$ }
    //#endif

    @FunctionalInterface
    public interface Receiver {
        void receive(Context context, class_2487 data);
    }

    public interface Context {
        class_1657 getPlayer();

        Env getEnv();

        void queue(Runnable runnable);
    }

    public enum Side {
        S2C, C2S
    }

    public enum Env {
        CLIENT, SERVER
    }

    //#if MC>1201
    @ApiStatus.Internal
    public record PacketPayload(class_2960 id,
                                class_2487 nbt) implements class_8710 {
        //#if MC>=1205
        public void write(RegistryFriendlyByteBuf buf) {
        //#else
        //$$ public PacketPayload(FriendlyByteBuf buf) {
        //$$     this(buf.readResourceLocation(), buf.readNbt());
        //$$ }
        //$$
        //$$ public void write(FriendlyByteBuf buf) {
            //#endif
            buf.writeResourceLocation(id);
            buf.writeNbt(nbt);
        }
    
        //#if MC>=1205
        
        public PacketPayload(RegistryFriendlyByteBuf buf) {
            this(buf.readResourceLocation(), buf.readNbt());
        }
        @Override
        public @NotNull Type<? extends class_8710> type() {
            return getType(id);
        }
        
        public static StreamCodec<RegistryFriendlyByteBuf, PacketPayload> streamCodec() {
            return new StreamCodec<>() {
                @Override
                public @NotNull PacketPayload decode(@NotNull RegistryFriendlyByteBuf buf) {
                    return new PacketPayload(buf);
                }
        
                @Override
                public void encode(@NotNull RegistryFriendlyByteBuf buf, @NotNull PacketPayload payload) {
                    buf.writeResourceLocation(payload.id);
                    buf.writeNbt(payload.nbt);
                }
            };
        }
        //#endif
    }
    //#endif
}
