package tocraft.craftedcore.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.craftedcore.data.PlayerDataProvider;
import tocraft.craftedcore.event.common.EntityEvents;
import tocraft.craftedcore.registration.PlayerDataRegistry;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

@SuppressWarnings({"unused", "DataFlowIssue"})
@Mixin(class_1657.class)
public abstract class PlayerMixin implements PlayerDataProvider {
    @Unique
    private final Map<String, class_2520> craftedcore$playerData = new HashMap<>();

    @Inject(method = "readAdditionalSaveData", at = @At("RETURN"))
    private void readNbt(class_2487 tag, CallbackInfo info) {
        for (String k : PlayerDataRegistry.keySet()) {
            craftedcore$playerData.put(k, tag.method_10580(k));
        }
    }

    @Inject(method = "addAdditionalSaveData", at = @At("RETURN"))
    private void writeNbt(class_2487 tag, CallbackInfo info) {
        craftedcore$playerData.forEach((k, v) -> {
            if (v != null && PlayerDataRegistry.isKeyRegistered(k)) {
                tag.method_10566(k, v);
            }
        });
    }

    @Inject(method = "interactOn", at = @At(value = "INVOKE",
            target = "Lnet/minecraft/world/entity/player/Player;getItemInHand(Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/item/ItemStack;",
            ordinal = 0),
            cancellable = true)
    private void onInteraction(class_1297 entity, class_1268 interactionHand, CallbackInfoReturnable<class_1269> cir) {
        class_1269 result = EntityEvents.INTERACT_WITH_PLAYER.invoke().interact((class_1657) (Object) this, entity, interactionHand);
        if (result != class_1269.field_5811) {
            cir.setReturnValue(result);
        }
    }

    @Unique
    @Override
    public Set<String> craftedcore$keySet() {
        return craftedcore$playerData.keySet();
    }

    @Unique
    @Override
    public void craftedcore$writeTag(String key, class_2520 tag) {
        craftedcore$playerData.put(key, tag);
    }

    @Unique
    @Override
    public class_2520 craftedcore$readTag(String key) {
        return craftedcore$playerData.get(key);
    }
}
