package tocraft.craftedcore.gui;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.CraftedCore;
import tocraft.craftedcore.patched.Identifier;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@SuppressWarnings("unused")
@Environment(EnvType.CLIENT)
public class TextureCache {
    private static final Map<String, class_2960> TEXTURE_CACHE = new ConcurrentHashMap<>();

    /**
     * Converts a URL to a readable id
     *
     * @param namespace the namespace in which the id should be saved
     * @param type for the id: "textures/entity/skin_123.png", choose: "entity"
     * @param prefix  for the id: "textures/entity/skin_123.png", choose: "skin". (some number will be auto-generated)
     * @param fileType the file type, e.g. "png"
     * @param textureURL the URL where the texture is found
     * @return the id if the texture could be cached or null, if there was an exception
     */
    @Nullable
    public static class_2960 getTextureId(String namespace, String type, String prefix, String fileType, URL textureURL) {
        return TEXTURE_CACHE.computeIfAbsent(String.valueOf(textureURL), key -> {
            class_2960 id = Identifier.parse(namespace, "textures/" + type + "/" + prefix + key.hashCode() + "." + fileType);
            try(InputStream is = textureURL.openStream()) {
                class_1011 image = class_1011.method_4309(new ByteArrayInputStream(is.readAllBytes()));
                class_1043 dynamicTexture = new class_1043(image);
                class_310.method_1551().method_1531().method_4616(id, dynamicTexture);
            } catch (IOException e) {
                CraftedCore.LOGGER.error("Caught an exception while reading url: {}", textureURL, e);
                return null;
            }
            return id;
        });
    }
}
