package tocraft.craftedcore.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_7654;
import tocraft.craftedcore.CraftedCore;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.patched.Identifier;
import tocraft.craftedcore.platform.PlatformData;

import java.io.*;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import com.mojang.logging.LogUtils;
import com.google.gson.JsonParseException;
//#else
//$$ import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
//#endif

/**
 * This is a SimpleJsonResourceReloadListener that synchronizes with every client and therefore should run serverside
 */
@SuppressWarnings("unused")
public abstract class SynchronizedJsonReloadListener extends
        //#if MC>=1212
        class_4080<Map<class_2960, JsonElement>>
        //#else
        //$$ SimpleJsonResourceReloadListener
        //#endif
{
    public final class_2960 RELOAD_SYNC;
    protected final String directory;
    protected final Gson gson;
    private final Map<class_2960, JsonElement> map = new HashMap<>();

    public SynchronizedJsonReloadListener(Gson gson, String directory) {
        //#if MC<1212
        //$$ super(gson, directory);
        //#endif
        this.gson = gson;
        this.directory = directory;
        this.RELOAD_SYNC = CraftedCore.id("data_sync_" + directory);
    }

    //#if MC>=1212
    protected @NotNull Map<class_2960, JsonElement> method_18789(class_3300 resourceManager, class_3695 profilerFiller) {
        Map<class_2960, JsonElement> map = new HashMap<>();
        scanDirectory(resourceManager, map);
        return map;
    }
    //#endif

    @Override
    protected void apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profiler) {
        this.map.clear();
        this.map.putAll(map);
        this.onApply(map);
    }

    protected abstract void onApply(Map<class_2960, JsonElement> map);

    public void sendSyncPacket(class_3222 player) {
        // Serialize unlocked to tag
        class_2487 compound = new class_2487();
        this.map.forEach((key, json) -> compound.method_10582(key.toString(), json.toString()));

        // Send to client
        ModernNetworking.sendToPlayer(player, RELOAD_SYNC, compound);
    }

    @Environment(EnvType.CLIENT)
    private void onPacketReceive(ModernNetworking.Context context, class_2487 compound) {
        this.map.clear();
        if (compound != null) {
            for (String key : compound.method_10541()) {
                this.map.put(Identifier.parse(key), JsonParser.parseString(compound.method_10558(key)));
            }
        }
        if (PlatformData.getEnv() == EnvType.CLIENT) {
            this.onApply(map);
        }
    }

    @Environment(EnvType.CLIENT)
    public void registerPacketReceiver() {
        ModernNetworking.registerReceiver(ModernNetworking.Side.S2C, RELOAD_SYNC, this::onPacketReceive);
    }

    //#if MC>=1212
    private void scanDirectory(class_3300 resourceManager, Map<class_2960, JsonElement> map) {
        class_7654 var4 = class_7654.method_45114(directory);
        Iterable<Map.Entry<class_2960, class_3298>> entrySet = var4.method_45113(resourceManager).entrySet();
        for(Map.Entry<class_2960, class_3298> entry : entrySet) {
            class_2960 var7 = entry.getKey();
            class_2960 var8 = var4.method_45115(var7);
            try {
                BufferedReader reader = entry.getValue().method_43039();
                try {
                    JsonElement var10 = class_3518.method_15276(gson, reader, JsonElement.class);
                    JsonElement var11 = map.put(var8, var10);
                    if (var11 != null) {
                        throw new IllegalStateException("Duplicate data file ignored with ID " + var8);
                    }
                } catch (Throwable var13) {
                    try {
                        reader.close();
                    } catch (Throwable var12) {
                        var13.addSuppressed(var12);
                    }
                    throw var13;
                }
                reader.close();
            } catch (IllegalArgumentException | IOException | JsonParseException var14) {
                LogUtils.getLogger().error("Couldn't parse data file {} from {}", var8, var7, var14);
            }
        }
    }
    //#endif
}
