package tocraft.craftedcore.config;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.CraftedCore;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.platform.PlatformData;

import java.nio.file.Path;

@SuppressWarnings("unused")
public interface Config {
    @Nullable
    String getName();

    @Nullable
    default Path getPath() {
        return getName() != null ? ConfigLoader.getConfigPath(getName()) : null;
    }

    default void save() {
        ConfigLoader.writeConfigFile(this);
    }

    default void sendToPlayer(class_3222 target) {
        ModernNetworking.sendToPlayer(target, ConfigLoader.CONFIG_SYNC, ConfigLoader.getConfigSyncTag(this));
    }

    default void sendToAllPlayers(class_3218 serverLevel) {
        for (class_3222 target : serverLevel.method_18456()) {
            sendToPlayer(target);
        }
    }

    @Nullable
    @Environment(EnvType.CLIENT)
    default class_437 constructConfigScreen(class_437 parent) {
        if (PlatformData.isModLoaded("cloth-config") || PlatformData.isModLoaded("cloth_config")) {
            return ClothConfigApi.constructConfigScreen(this, parent);
        } else {
            CraftedCore.LOGGER.warn("Cloth config not found!");
            return null;
        }
    }
}
