package tocraft.craftedcore.network.fabric;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import tocraft.craftedcore.network.ModernNetworking;

@SuppressWarnings({"unused", "resource"})
public class ModernNetworkingImpl {
    public static void registerReceiver(ModernNetworking.Side side, class_2960 id, ModernNetworking.Receiver receiver) {
        if (side == ModernNetworking.Side.C2S) {
            ServerPlayNetworking.registerGlobalReceiver(id, (server, player, handler, buf, responseSender) -> {
                CompoundTag data = buf.readNbt();
                receiver.receive(new ModernNetworking.Context() {
                    @Override
                    public Player getPlayer() {
                        return player;
                    }

                    @Override
                    public ModernNetworking.Env getEnv() {
                        return ModernNetworking.Env.SERVER;
                    }

                    @Override
                    public void queue(Runnable runnable) {
                        server.execute(runnable);
                    }
                }, data);
            });
        } else if (side == ModernNetworking.Side.S2C) {
            ClientPlayNetworking.registerGlobalReceiver(id, (client, handler, buf, responseSender) -> {
                CompoundTag data = buf.readNbt();
                receiver.receive(new ModernNetworking.Context() {
                    @Override
                    public Player getPlayer() {
                        return client.player;
                    }

                    @Override
                    public ModernNetworking.Env getEnv() {
                        return ModernNetworking.Env.CLIENT;
                    }

                    @Override
                    public void queue(Runnable runnable) {
                        client.execute(runnable);
                    }
                }, data);
            });
        }
    }

    @ApiStatus.Internal
    public static class_2596<?> toPacket(ModernNetworking.Side side, class_2960 id, class_2540 buf) {
        if (side == ModernNetworking.Side.C2S) {
            return new class_2817(buf);
        } else {
            return new class_2658(buf);
        }
    }
}
