package tocraft.craftedcore.event.client;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.event.Event;
import tocraft.craftedcore.event.EventFactory;

@SuppressWarnings({"unused", "SameReturnValue"})
@Environment(EnvType.CLIENT)
public final class RenderEvents {
    public static final Event<HUDRendering> HUD_RENDERING = EventFactory.createWithVoid();
    public static final Event<OverlayRendering> RENDER_HEALTH = EventFactory.createWithInteractionResult();
    public static final Event<OverlayRendering> RENDER_FOOD = EventFactory.createWithInteractionResult();
    public static final Event<OverlayRendering> RENDER_BREATH = EventFactory.createWithInteractionResult();
    public static final Event<OverlayRendering> RENDER_MOUNT_HEALTH = EventFactory.createWithInteractionResult();

    @Environment(EnvType.CLIENT)
    @FunctionalInterface
    public interface HUDRendering {
        void render(class_332 graphics, float tickDelta);
    }

    @Environment(EnvType.CLIENT)
    @FunctionalInterface
    public interface OverlayRendering {
        class_1269 render(@Nullable class_332 graphics, class_1657 player);
    }
}
