/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.platform.fabric;

import java.lang.module.ModuleDescriptor;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.Nullable;

public final class PlatformDataImpl {
    public static boolean isModLoaded(String modid) {
        return FabricLoader.getInstance().isModLoaded(modid);
    }

    @Nullable
    public static ModuleDescriptor.Version getModVersion(String modid) {
        return FabricLoader.getInstance().getModContainer(modid).map(modContainer -> ModuleDescriptor.Version.parse(modContainer.getMetadata().getVersion().getFriendlyString())).orElse(null);
    }

    public static boolean isDevEnv() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    public static EnvType getEnv() {
        return FabricLoader.getInstance().getEnvironmentType();
    }

    public static Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir();
    }

    public static ModLoader getModLoaderId() {
        return ModLoader.FABRIC;
    }

    public static enum ModLoader {
        FABRIC,
        FORGE,
        NEOFORGE,
        OTHER;

    }
}

