package tocraft.craftedcore.config;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import org.jetbrains.annotations.Nullable;

import java.nio.file.Path;
import java.util.List;
import net.minecraft.class_2540;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public interface Config {
    /**
     * This should be overwritten to improve the performance and avoid errors
     */
    @Nullable
    default String getName() {
        List<String> possibleNames = ConfigLoader.getConfigNames(this);
        return !possibleNames.isEmpty() ? possibleNames.get(0) : null;
    }

    @Nullable
    default Path getPath() {
        return getName() != null ? ConfigLoader.getConfigPath(getName()) : null;
    }

    default void save() {
        ConfigLoader.writeConfigFile(this);
    }

    default void sendToPlayer(class_3222 target) {
        class_2540 packet = new class_2540(Unpooled.buffer());

        packet.method_10794(ConfigLoader.getConfigSyncTag(this));
        NetworkManager.sendToPlayer(target, ConfigLoader.CONFIG_SYNC, packet);
    }

    default void sendToAllPlayers(class_3218 serverLevel) {
        for (class_3222 target : serverLevel.method_18456()) {
            sendToPlayer(target);
        }
    }
}
