package tocraft.craftedcore.network;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

@SuppressWarnings("ALL")
public final class ModernNetworking {
    public static void registerReceiver(Side side, class_2960 id, Receiver receiver) {
        NetworkManager.registerReceiver(side == Side.C2S ? NetworkManager.Side.C2S : NetworkManager.Side.S2C, id, (packet, context) -> receiver.receive(new Context() {
            @Override
            public class_1657 getPlayer() {
                return context.getPlayer();
            }

            @Override
            public EnvType getEnv() {
                return context.getEnv();
            }

            @Override
            public void queue(Runnable runnable) {
                context.queue(runnable);
            }
        }, packet.method_10798()));
    }

    public static void sendToPlayer(class_3222 player, class_2960 packetId, class_2487 data) {
        class_2540 buf = new class_2540((Unpooled.buffer()));
        buf.method_10794(data);
        NetworkManager.sendToPlayer(player, packetId, buf);
    }

    public static void sendToPlayers(Iterable<class_3222> players, class_2960 packetId, class_2487 data) {
        for (class_3222 player : players) {
            class_2540 buf = new class_2540((Unpooled.buffer()));
            buf.method_10794(data);
            NetworkManager.sendToPlayer(player, packetId, buf);
        }
    }

    @Environment(EnvType.CLIENT)
    public static void sendToServer(class_2960 packetId, class_2487 data) {
        class_2540 buf = new class_2540((Unpooled.buffer()));
        buf.method_10794(data);
        NetworkManager.sendToServer(packetId, buf);
    }

    @FunctionalInterface
    public interface Receiver {
        void receive(Context context, class_2487 data);
    }

    public interface Context {
        class_1657 getPlayer();

        EnvType getEnv();

        void queue(Runnable runnable);
    }

    public enum Side {
        S2C, C2S
    }
}
