package tocraft.craftedcore.event.common;

import net.minecraft.class_1269;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.event.Event;
import tocraft.craftedcore.event.EventFactory;

@SuppressWarnings("unused")
public final class PlayerEvents {
    public static final Event<PlayerJoin> PLAYER_JOIN = EventFactory.createWithVoid();
    public static final Event<PlayerQuit> PLAYER_QUIT = EventFactory.createWithVoid();
    /**
     * Called when the player is recreated
     */
    public static final Event<PlayerRespawn> PLAYER_RESPAWN = EventFactory.createWithVoid();
    public static final Event<AwardAdvancement> AWARD_ADVANCEMENT = EventFactory.createWithVoid();
    public static final Event<RevokeAdvancement> REVOKE_ADVANCEMENT = EventFactory.createWithVoid();
    public static final Event<AllowSleepTime> ALLOW_SLEEP_TIME = EventFactory.createWithVoid();
    public static final Event<SleepFinishedTime> SLEEP_FINISHED_TIME = EventFactory.createWithCallback(callbacks -> (level, newTime) -> {
        long newNewTime = 0;
        for (SleepFinishedTime callback : callbacks) {
            long newTimeIn = callback.setTimeAddition(level, newTime);
            if (level.method_8532() <= newTimeIn) {
                newNewTime = newTimeIn;
            }
        }
        return newNewTime;
    });

    @FunctionalInterface
    public interface PlayerJoin {
        void join(class_3222 player);
    }

    @FunctionalInterface
    public interface PlayerQuit {
        void quit(class_3222 player);
    }

    @FunctionalInterface
    public interface PlayerRespawn {
        void clone(class_3222 oldPlayer, class_3222 newPlayer);
    }

    @FunctionalInterface
    public interface AwardAdvancement {
        void award(class_3222 player, class_161 advancement, String criterionKey);
    }

    @FunctionalInterface
    public interface RevokeAdvancement {
        void revoke(class_3222 player, class_161 advancement, String criterionKey);
    }

    @FunctionalInterface
    public interface AllowSleepTime {
        class_1269 allowSleepTime(class_1657 player, @Nullable class_2338 sleepingPos, boolean vanillaResult);
    }

    @FunctionalInterface
    public interface SleepFinishedTime {
        long setTimeAddition(class_3218 level, long newTime);
    }
}
