/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore;

import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_310;
import tocraft.craftedcore.CraftedCore;

public class VIPs {
    public static final String patreonURL = "https://tocraft.dev/patreons.txt";
    private static final List<UUID> CACHED_PATREONS = new ArrayList<UUID>();

    public static List<UUID> getCachedPatreons() {
        if (CACHED_PATREONS.isEmpty()) {
            CACHED_PATREONS.addAll(VIPs.getPatreons());
        }
        return CACHED_PATREONS;
    }

    public static List<UUID> getPatreons() {
        try {
            return VIPs.getUUIDOfPeople(new URL(patreonURL));
        }
        catch (MalformedURLException e) {
            VIPs.throwError(e);
            return new ArrayList<UUID>();
        }
    }

    public static List<UUID> getUUIDOfPeople(URL url) {
        ArrayList<UUID> people = new ArrayList<UUID>();
        try {
            String line;
            BufferedReader updateReader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
            while ((line = updateReader.readLine()) != null && (line = line.replaceAll("\n", "")).isBlank()) {
                people.add(UUID.fromString(line));
            }
            updateReader.close();
        }
        catch (IOException e) {
            VIPs.throwError(e);
        }
        if (Platform.getEnvironment() == Env.CLIENT && people.contains(class_310.method_1551().method_1548().method_44717())) {
            CraftedCore.LOGGER.info("Thank you for supporting me and my mods! ~To_Craft");
        }
        return people;
    }

    private static void throwError(IOException e) {
        CraftedCore.LOGGER.error("Couldn't get all patreons from https://tocraft.dev/patreons.txt");
        CraftedCore.LOGGER.error(e.getLocalizedMessage());
    }
}

