/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.platform;

import dev.architectury.platform.Mod;
import dev.architectury.platform.Platform;
import java.lang.module.ModuleDescriptor;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import org.jetbrains.annotations.Nullable;

public final class PlatformData {
    public static boolean isModLoaded(String modid) {
        return Platform.isModLoaded((String)modid);
    }

    @Nullable
    public static ModuleDescriptor.Version getModVersion(String modid) {
        Mod mod = Platform.getMod((String)modid);
        return mod != null ? ModuleDescriptor.Version.parse(mod.getVersion()) : null;
    }

    public static boolean isDevEnv() {
        return Platform.isDevelopmentEnvironment();
    }

    public static EnvType getEnv() {
        return Platform.getEnv();
    }

    public static Path getConfigPath() {
        return Platform.getConfigFolder();
    }

    public static ModLoader getModLoaderId() {
        if (Platform.isFabric()) {
            return ModLoader.FABRIC;
        }
        if (Platform.isForge()) {
            return ModLoader.FORGE;
        }
        return ModLoader.OTHER;
    }

    public static enum ModLoader {
        FABRIC,
        FORGE,
        NEOFORGE,
        OTHER;

    }
}

