/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.platform;

import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import net.minecraft.class_2561;
import tocraft.craftedcore.CraftedCore;

public class VersionChecker {
    public static void registerMavenChecker(String modid, URL mavenURL, class_2561 modName) {
        VersionChecker.registerChecker(modid, mavenURL, "<version>" + Platform.getMinecraftVersion() + "-", "</version>", modName);
    }

    public static void registerChecker(String modid, URL urlToCheck, String linePrefix, String lineSuffix, class_2561 modName) {
        PlayerEvent.PLAYER_JOIN.register(player -> {
            if (CraftedCore.CONFIG != null && CraftedCore.CONFIG.enableVersionChecking) {
                String newestVersion = Platform.getMod((String)modid).getVersion();
                try {
                    newestVersion = VersionChecker.checkForNewVersion(urlToCheck, linePrefix, lineSuffix);
                    if (newestVersion.isBlank()) {
                        CraftedCore.LOGGER.warn("Failed to get the newest version for " + modName.getString() + " from " + urlToCheck + ".");
                        return;
                    }
                }
                catch (IOException e) {
                    CraftedCore.LOGGER.warn("Failed to get the newest version for " + modName.getString() + " from " + urlToCheck + ": " + e.getMessage());
                }
                if (!newestVersion.equals(Platform.getMod((String)modid).getVersion())) {
                    player.method_43496((class_2561)class_2561.method_43469((String)"craftedcore.update", (Object[])new Object[]{modName, newestVersion}));
                }
            }
        });
    }

    public static String checkForNewVersion(URL urlToCheck, String linePrefix, String lineSuffix) throws IOException {
        String line;
        BufferedReader updateReader = new BufferedReader(new InputStreamReader(urlToCheck.openStream(), StandardCharsets.UTF_8));
        while ((line = updateReader.readLine()) != null) {
            if (!(line = line.replaceAll(" ", "")).startsWith(linePrefix) || !line.endsWith(lineSuffix)) continue;
            return line.split(linePrefix)[1].split(lineSuffix)[0];
        }
        updateReader.close();
        return "";
    }
}

