package tocraft.craftedcore.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_408;
//#if MC>1194
import net.minecraft.client.gui.GuiGraphics;

@SuppressWarnings("unused")
public class TimerOverlayRenderer {

    private static final int fadingTickRequirement = 0;
    private static int ticksSinceUpdate = 0;
    private static boolean isFading = false;
    private static int fadingProgress = 0;

    //#if MC>1194
    public static void register(GuiGraphics graphics, int currentCooldown, int maxCooldown, class_1792 item) {
    //#else
    //$$ public static void register(PoseStack graphics, int currentCooldown, int maxCooldown, Item item) {
    //#endif
        class_310 client = class_310.method_1551();

        if (client.field_1755 instanceof class_408 || currentCooldown <= 0 || item == null) {
            return;
        }

        double d = client.method_22683().method_4495();
        float cooldownScale = 1 - currentCooldown / (float) maxCooldown;

        // cooldown has NOT updated since last tick. It is most likely full.
        if (ticksSinceUpdate > fadingProgress) {
            ticksSinceUpdate = 0;
            isFading = false;
        }

        // Tick fading
        if (isFading) {
            fadingProgress = Math.min(50, fadingProgress + 1);
        } else {
            fadingProgress = Math.max(0, fadingProgress - 1);
        }

        if (client.field_1724 != null) {
            int width = class_310.method_1551().method_22683().method_4486();
            int height = class_310.method_1551().method_22683().method_4502();

            //#if MC>1194
            graphics.pose().pushPose();
            //#else
            //$$ graphics.pushPose();
            //#endif
            if (cooldownScale != 1) {
                RenderSystem.enableScissor(
                        (int) ((double) 0 * d),
                        (int) ((double) 0 * d),
                        (int) ((double) width * d),
                        (int) ((double) height * (.02 + .055 * cooldownScale) * d)); // min is 0.21, max is 0.76. dif = .55
            }

            // ending pop
            if (isFading) {
                float fadeScalar = fadingProgress / 50f; // 0f -> 1f, 0 is start, 1 is end
                float scale = 1f + (float) Math.sin(fadeScalar * 1.5 * Math.PI) - .25f;
                scale = Math.max(scale, 0);
                //#if MC>1194
                graphics.pose().scale(scale, scale, scale);
                //#else
                //$$ graphics.scale(scale, scale, scale);
                //#endif
            }

            class_1799 stack = new class_1799(item);
            //#if MC>1194
            graphics.renderItem(stack, (int) (width * .95f), (int) (height * .92f));
            //#elseif MC>1182
            //$$ Minecraft.getInstance().getItemRenderer().renderGuiItem(graphics, stack, (int) (width * .95f), (int) (height * .92f));
            //#else
            //$$ Minecraft.getInstance().getItemRenderer().renderGuiItem(stack, (int) (width * .95f), (int) (height * .92f));
            //#endif

            RenderSystem.disableScissor();
            //#if MC>1194
            graphics.pose().popPose();
            //#else
            //$$ graphics.popPose();
            //#endif
        }
    }
}
