/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.platform;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.channels.UnresolvedAddressException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.CraftedCore;
import tocraft.craftedcore.CraftedCoreConfig;
import tocraft.craftedcore.gui.TextureCache;
import tocraft.craftedcore.util.NetUtils;

public record PlayerProfile(@NotNull String name, @NotNull UUID id, @Nullable URL skin, boolean isSlim, @Nullable URL cape) {
    private static final Map<String, UUID> NAME_TO_UUID_CACHE = new ConcurrentHashMap<String, UUID>();
    private static final Map<UUID, PlayerProfile> UUID_TO_PROFILE_CACHE = new ConcurrentHashMap<UUID, PlayerProfile>();
    private static final Path CACHE_DIR = CraftedCore.CACHE_DIR.resolve("player_profiles");
    private static final Path CACHE_PROFILES_DIR = CACHE_DIR.resolve("profiles");
    private static final Path CACHE_SKINS_DIR = CACHE_DIR.resolve("skins");
    private static final Path CACHE_CAPES_DIR = CACHE_DIR.resolve("capes");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    @ApiStatus.Internal
    public static void mkdirs() {
        CACHE_DIR.toFile().mkdirs();
        CACHE_PROFILES_DIR.toFile().mkdirs();
        CACHE_SKINS_DIR.toFile().mkdirs();
        CACHE_CAPES_DIR.toFile().mkdirs();
    }

    @ApiStatus.Internal
    public static void initialize() {
        try {
            PlayerProfile.loadAll();
        }
        catch (IOException e) {
            CraftedCore.LOGGER.error("Caught an exception.", (Throwable)e);
        }
    }

    @ApiStatus.Internal
    public static void clearCache() {
        NAME_TO_UUID_CACHE.clear();
        UUID_TO_PROFILE_CACHE.clear();
        CraftedCore.forceDeleteFile(CACHE_DIR.toFile());
    }

    @Nullable
    public static PlayerProfile getCachedProfile(UUID id) {
        return UUID_TO_PROFILE_CACHE.get(id);
    }

    @Nullable
    public static UUID getCachedId(String name) {
        return NAME_TO_UUID_CACHE.get(name);
    }

    @Nullable
    public static PlayerProfile getCachedProfile(String name) {
        UUID id = PlayerProfile.getCachedId(name);
        if (id != null) {
            return UUID_TO_PROFILE_CACHE.get(id);
        }
        return null;
    }

    @Nullable
    public static UUID getUUID(@NotNull String name) {
        UUID cached;
        if (CraftedCoreConfig.INSTANCE.autoUpdateCache && (cached = NAME_TO_UUID_CACHE.get(name)) != null) {
            CompletableFuture.runAsync(() -> PlayerProfile._getUUID(name));
            return cached;
        }
        return NAME_TO_UUID_CACHE.computeIfAbsent(name, key -> PlayerProfile._getUUID(name));
    }

    @ApiStatus.Internal
    @Nullable
    private static UUID _getUUID(@NotNull String name) {
        try {
            JsonElement response = NetUtils.getJsonResponse(GSON, new URI("https://api.mojang.com/users/profiles/minecraft/" + name).toURL());
            if (response == null) {
                return null;
            }
            JsonObject lookup = response.getAsJsonObject();
            return PlayerProfile.stringToUUID(lookup.get("id").getAsString());
        }
        catch (IOException | URISyntaxException | UnresolvedAddressException e) {
            if (e instanceof UnresolvedAddressException || e instanceof SocketException || e instanceof UnknownHostException) {
                CraftedCore.reportMissingInternet(e);
            } else {
                CraftedCore.LOGGER.error("Caught an exception.", (Throwable)e);
            }
            return null;
        }
    }

    @Nullable
    public static PlayerProfile ofName(@NotNull String name) {
        UUID uuid = PlayerProfile.getUUID(name);
        return uuid != null ? PlayerProfile.ofId(uuid) : null;
    }

    @Nullable
    public static PlayerProfile ofId(@NotNull UUID uuid) {
        PlayerProfile cached;
        if (CraftedCoreConfig.INSTANCE.autoUpdateCache && (cached = UUID_TO_PROFILE_CACHE.get(uuid)) != null) {
            CompletableFuture.runAsync(() -> PlayerProfile._ofId(uuid));
            return cached;
        }
        return UUID_TO_PROFILE_CACHE.computeIfAbsent(uuid, key -> PlayerProfile._ofId(uuid));
    }

    @ApiStatus.Internal
    @Nullable
    private static PlayerProfile _ofId(@NotNull UUID uuid) {
        JsonObject profile;
        try {
            JsonElement response = NetUtils.getJsonResponse(GSON, new URI("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid.toString().replace("-", "")).toURL());
            if (response == null) {
                return null;
            }
            profile = response.getAsJsonObject();
        }
        catch (IOException | URISyntaxException | UnresolvedAddressException e) {
            CraftedCore.LOGGER.error("Caught an exception.", (Throwable)e);
            return null;
        }
        JsonArray properties = profile.get("properties").getAsJsonArray();
        JsonObject textures = null;
        for (JsonElement property : properties) {
            JsonObject propertyObject;
            if (!property.isJsonObject() || !Objects.equals((propertyObject = property.getAsJsonObject()).get("name").getAsString(), "textures")) continue;
            String decodedProperties = new String(Base64.getDecoder().decode(propertyObject.get("value").getAsString()), StandardCharsets.UTF_8);
            JsonObject jsonProperties = ((JsonElement)GSON.fromJson(decodedProperties, JsonElement.class)).getAsJsonObject();
            textures = jsonProperties.get("textures").getAsJsonObject();
            break;
        }
        String name = profile.get("name").getAsString();
        URL skin = null;
        boolean isSlim = false;
        URL cape = null;
        if (textures != null) {
            if (textures.has("SKIN")) {
                JsonObject metadata;
                JsonObject skinJson = textures.get("SKIN").getAsJsonObject();
                try {
                    skin = new URI(skinJson.get("url").getAsString()).toURL();
                }
                catch (MalformedURLException | URISyntaxException e) {
                    CraftedCore.LOGGER.error("Caught an exception.", (Throwable)e);
                    return null;
                }
                if (skinJson.has("metadata") && (metadata = skinJson.get("metadata").getAsJsonObject()).has("model")) {
                    isSlim = Objects.equals(metadata.get("model").getAsString(), "slim");
                }
            }
            if (textures.has("CAPE")) {
                try {
                    cape = new URI(textures.get("CAPE").getAsJsonObject().get("url").getAsString()).toURL();
                }
                catch (MalformedURLException | URISyntaxException e) {
                    CraftedCore.LOGGER.error("Caught an exception.", (Throwable)e);
                    return null;
                }
            }
        }
        PlayerProfile playerProfile = new PlayerProfile(name, uuid, skin, isSlim, cape);
        try {
            playerProfile.save();
        }
        catch (IOException e) {
            CraftedCore.LOGGER.error("Caught an exception.", (Throwable)e);
        }
        return playerProfile;
    }

    private static UUID stringToUUID(String input) throws IllegalArgumentException {
        try {
            return UUID.fromString(input);
        }
        catch (IllegalArgumentException e) {
            return UUID.fromString(input.replaceFirst("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5"));
        }
    }

    @Nullable
    public class_2960 getSkinId() {
        if (this.skin != null) {
            return TextureCache.getTextureId("craftedcore", "entity", "custom_skin_", "png", this.skin);
        }
        return null;
    }

    @Nullable
    public class_2960 getCapeId() {
        if (this.cape != null) {
            return TextureCache.getTextureId("craftedcore", "entity", "custom_cape_", "png", this.cape);
        }
        return null;
    }

    @ApiStatus.Internal
    public JsonObject toJson() {
        return GSON.toJsonTree((Object)this).getAsJsonObject();
    }

    @ApiStatus.Internal
    public static PlayerProfile ofJson(JsonObject json) {
        return (PlayerProfile)GSON.fromJson((JsonElement)json, PlayerProfile.class);
    }

    @ApiStatus.Internal
    public void save() throws IOException {
        InputStream is;
        PlayerProfile.mkdirs();
        JsonObject json = this.toJson();
        if (this.skin != null) {
            Path cachedSkin = CACHE_SKINS_DIR.resolve(String.valueOf(this.id) + ".png");
            is = this.skin.openStream();
            try {
                Files.write(cachedSkin, is.readAllBytes(), new OpenOption[0]);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
            json.addProperty("skin", cachedSkin.toFile().toURI().toURL().toString());
        }
        if (this.cape != null) {
            Path cachedCape = CACHE_CAPES_DIR.resolve(String.valueOf(this.id) + ".png");
            is = this.cape.openStream();
            try {
                Files.write(cachedCape, is.readAllBytes(), new OpenOption[0]);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
            json.addProperty("cape", cachedCape.toFile().toURI().toURL().toString());
        }
        Files.writeString(CACHE_PROFILES_DIR.resolve(String.valueOf(this.id()) + ".json"), (CharSequence)GSON.toJson((JsonElement)json), new OpenOption[0]);
    }

    @ApiStatus.Internal
    public static PlayerProfile load(UUID id) throws IOException {
        PlayerProfile.mkdirs();
        String s = Files.readString(CACHE_PROFILES_DIR.resolve(String.valueOf(id) + ".json"));
        JsonObject json = (JsonObject)GSON.fromJson(s, JsonObject.class);
        return PlayerProfile.ofJson(json);
    }

    public static void loadAll() throws IOException {
        PlayerProfile.mkdirs();
        try (Stream<Path> stream = Files.list(CACHE_PROFILES_DIR);){
            for (Path path : (Path[])stream.toArray(Path[]::new)) {
                if (path.toString().endsWith(".json")) {
                    String s = Files.readString(path);
                    JsonObject json = (JsonObject)GSON.fromJson(s, JsonObject.class);
                    PlayerProfile profile = PlayerProfile.ofJson(json);
                    NAME_TO_UUID_CACHE.put(profile.name, profile.id);
                    UUID_TO_PROFILE_CACHE.put(profile.id, profile);
                    continue;
                }
                System.out.println(path);
            }
        }
    }
}

