package tocraft.craftedcore.registration;

import dev.architectury.injectables.annotations.ExpectPlatform;
import net.fabricmc.api.EnvType;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.ApiStatus;
import tocraft.craftedcore.data.SynchronizedJsonReloadListener;
import tocraft.craftedcore.event.common.ResourceEvents;
import tocraft.craftedcore.platform.PlatformData;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@SuppressWarnings("UnreachableCode")
public class SynchronizedReloadListenerRegistry {
    private static final Map<class_2960, SynchronizedJsonReloadListener> listener = new HashMap<>();

    /**
     * Register a serverside synchronized json reload listener
     */
    @SuppressWarnings("unused")
    public static void register(SynchronizedJsonReloadListener reloadListener, class_2960 id) {
        listener.put(id, reloadListener);

        // Register Data Packet receiver
        if (PlatformData.getEnv() == EnvType.CLIENT) {
            reloadListener.registerPacketReceiver();
        }

        onRegister(reloadListener, id);
    }

    @SuppressWarnings("unused")
    @ApiStatus.Internal
    @ExpectPlatform
    private static void onRegister(SynchronizedJsonReloadListener reloadListener, class_2960 id) {
        throw new AssertionError();
    }

    @ApiStatus.Internal
    public static List<SynchronizedJsonReloadListener> getAllListener() {
        return new ArrayList<>(listener.values());
    }

    @SuppressWarnings("unused")
    public static SynchronizedJsonReloadListener get(class_2960 id) {
        return listener.get(id);
    }

    public static void initialize() {
        ResourceEvents.DATA_PACK_SYNC.register(SynchronizedReloadListenerRegistry::sendAllToPlayer);
    }

    private static void sendAllToPlayer(class_3222 player) {
        for (SynchronizedJsonReloadListener reloadListener : listener.values()) {
            reloadListener.sendSyncPacket(player);
        }
    }
}
