package tocraft.craftedcore.network;

import dev.architectury.injectables.annotations.ExpectPlatform;
import io.netty.buffer.Unpooled;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_634;
import org.jetbrains.annotations.ApiStatus;

@SuppressWarnings("unused")
public class ModernNetworking {
    @ExpectPlatform
    public static void registerReceiver(Side side, class_2960 id, Receiver receiver) {
        throw new AssertionError();
    }

    public static void sendToPlayer(class_3222 player, class_2960 packetId, class_2487 data) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10812(packetId);
        buf.method_10794(data.method_10553());
        player.field_13987.method_14364(toPacket(Side.S2C, packetId, buf));
    }

    public static void sendToPlayers(Iterable<class_3222> players, class_2960 packetId, class_2487 data) {
        for (class_3222 player : players) {
            sendToPlayer(player, packetId, data);
        }
    }

    @Environment(EnvType.CLIENT)
    public static void sendToServer(class_2960 packetId, class_2487 data) {
        class_634 connection = class_310.method_1551().method_1562();

        if (connection != null) {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.method_10812(packetId);
            buf.method_10794(data.method_10553());
            connection.method_2883(toPacket(Side.C2S, packetId, buf));
        }
    }

    @ExpectPlatform
    @ApiStatus.Internal
    public static class_2596<?> toPacket(ModernNetworking.Side side, class_2960 id, class_2540 buf) {
        throw new AssertionError();
    }

    @FunctionalInterface
    public interface Receiver {
        void receive(Context context, class_2487 data);
    }

    public interface Context {
        class_1657 getPlayer();

        Env getEnv();

        void queue(Runnable runnable);
    }

    public enum Side {
        S2C, C2S
    }

    public enum Env {
        CLIENT, SERVER
    }
}
