package tocraft.craftedcore.mixin;

import net.minecraft.class_2535;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.craftedcore.event.common.PlayerEvents;
import tocraft.craftedcore.event.common.ResourceEvents;

@SuppressWarnings("unused")
@Mixin(class_3324.class)
public class PlayerListMixin {
    @ModifyArg(method = "reloadResources", at = @At(value = "INVOKE", target = "Lnet/minecraft/stats/ServerRecipeBook;sendInitialRecipeBook(Lnet/minecraft/server/level/ServerPlayer;)V"))
    private class_3222 endResourceReload(class_3222 player) {
        ResourceEvents.DATA_PACK_SYNC.invoke().onSync(player);
        return player;
    }


    @Inject(method = "placeNewPlayer", at = @At("RETURN"))
    private void placeNewPlayer(class_2535 connection, class_3222 serverPlayer, CallbackInfo ci) {
        PlayerEvents.PLAYER_JOIN.invoke().join(serverPlayer);
        ResourceEvents.DATA_PACK_SYNC.invoke().onSync(serverPlayer);
    }

    @Inject(method = "remove", at = @At("HEAD"))
    private void remove(class_3222 serverPlayer, CallbackInfo ci) {
        PlayerEvents.PLAYER_QUIT.invoke().quit(serverPlayer);
    }
}
