package tocraft.craftedcore.mixin;

import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_636;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.craftedcore.event.common.EntityEvents;

@Mixin(class_636.class)
public class MultiPlayerGameModeMixin {
    @Inject(method = "interact",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/client/multiplayer/ClientPacketListener;send(Lnet/minecraft/network/protocol/Packet;)V",
                    shift = At.Shift.AFTER),
            cancellable = true)
    private void entityInteract(class_1657 player, class_1297 entity, class_1268 interactionHand, CallbackInfoReturnable<class_1269> cir) {
        class_1269 result = EntityEvents.INTERACT_WITH_PLAYER.invoke().interact(player, entity, interactionHand);
        if (result != class_1269.field_5811) {
            cir.setReturnValue(result);
        }
    }
}
