package tocraft.craftedcore.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_408;
import net.minecraft.class_4587;

@SuppressWarnings("unused")
public class TimerOverlayRenderer {

    private static final int fadingTickRequirement = 0;
    private static int ticksSinceUpdate = 0;
    private static boolean isFading = false;
    private static int fadingProgress = 0;

    public static void register(class_4587 graphics, int currentCooldown, int maxCooldown, class_1792 item) {
        class_310 client = class_310.method_1551();

        if (client.field_1755 instanceof class_408 || currentCooldown <= 0 || item == null) {
            return;
        }

        double d = client.method_22683().method_4495();
        float cooldownScale = 1 - currentCooldown / (float) maxCooldown;

        // cooldown has NOT updated since last tick. It is most likely full.
        if (ticksSinceUpdate > fadingProgress) {
            ticksSinceUpdate = 0;
            isFading = false;
        }

        // Tick fading
        if (isFading) {
            fadingProgress = Math.min(50, fadingProgress + 1);
        } else {
            fadingProgress = Math.max(0, fadingProgress - 1);
        }

        if (client.field_1724 != null) {
            int width = class_310.method_1551().method_22683().method_4486();
            int height = class_310.method_1551().method_22683().method_4502();

            graphics.method_22903();
            if (cooldownScale != 1) {
                RenderSystem.enableScissor(
                        (int) ((double) 0 * d),
                        (int) ((double) 0 * d),
                        (int) ((double) width * d),
                        (int) ((double) height * (.02 + .055 * cooldownScale) * d)); // min is 0.21, max is 0.76. dif = .55
            }

            // ending pop
            if (isFading) {
                float fadeScalar = fadingProgress / 50f; // 0f -> 1f, 0 is start, 1 is end
                float scale = 1f + (float) Math.sin(fadeScalar * 1.5 * Math.PI) - .25f;
                scale = Math.max(scale, 0);
                graphics.method_22905(scale, scale, scale);
            }

            class_1799 stack = new class_1799(item);
            class_310.method_1551().method_1480().method_4010(stack, (int) (width * .95f), (int) (height * .92f));

            RenderSystem.disableScissor();
            graphics.method_22909();
        }
    }
}
