package tocraft.craftedcore.data;

import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import tocraft.craftedcore.CraftedCore;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.network.client.ClientNetworking;
import tocraft.craftedcore.registration.PlayerDataRegistry;

public class PlayerDataSynchronizer {
    private static final String PLAYER_DATA_SYNC = "player_data_sync";
    public static final class_2960 PLAYER_DATA_SYNC_ID = CraftedCore.id(PLAYER_DATA_SYNC);

    public static void registerPacketHandler() {
        ModernNetworking.registerReceiver(ModernNetworking.Side.S2C, PLAYER_DATA_SYNC_ID, (context, tag) -> {
            if (tag != null) {
                class_2499 list = (class_2499) tag.method_10580(PLAYER_DATA_SYNC);
                if (list != null) {
                    for (class_2520 entry : list) {
                        for (String key : ((class_2487) entry).method_10541()) {
                            ClientNetworking.runOrQueue(context, player -> ((PlayerDataProvider) player).craftedcore$writeTag(key, ((class_2487) entry).method_10580(key)));
                        }
                    }
                }
            }
        });
    }

    /**
     * Synchronize data from the server to the client
     */
    public static void sync(class_3222 player) {
        class_2487 tag = new class_2487();
        class_2499 list = new class_2499();

        PlayerDataProvider playerData = ((PlayerDataProvider) player);

        for (String key : ((PlayerDataProvider) player).craftedcore$keySet()) {
            // ignore key if it shouldn't be synchronized to the client
            if (!PlayerDataRegistry.shouldSyncKey(key))
                return;

            class_2487 entry = new class_2487();
            entry.method_10566(key, playerData.craftedcore$readTag(key));
            list.add(entry);
        }
        tag.method_10566(PLAYER_DATA_SYNC, list);
        ModernNetworking.sendToPlayer(player, PLAYER_DATA_SYNC_ID, tag);
    }
}
